/*###############################################################################
# Linux Management Providers (LMP), IP provider package
# Copyright (C) 2007 Ilsoo Byun <widepis@etri.re.kr ,widepis@empal.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#ifndef IP_COMMON_H_
#define IP_COMMON_H_

#include <Common.h>

// Define EnabledState Constants
#define ES_UNKNOWN			0
#define ES_ENABLE			2
#define ES_DISABLE			3
#define ES_NOT_APPLICABLE	5
#define ES_ENABLED_OFFLINE	6

// Define RequestedState Constants
#define RS_UNKNOWN			0
#define RS_NO_CHANGE		5
#define RS_NOT_APPLICABLE	12

// Define EnabledDefault Constants
#define ED_ENABLE			2
#define ED_DISABLE			3

// Define AddressOrigin Constants
#define AO_UNKNOWN			0
#define AO_STATIC			3
#define AO_DHCP				4
#define AO_BOOTP			5

// Define ProtocolIFType Constants
#define IFTYPE_IPv4			4096

static const string DEVICE_BASE_PATH = "/etc/sysconfig/network-scripts/";
static const string DEBIAN_DEVICE_FILE = "/etc/network/interfaces";

//
int CF_getGatewayByInterface(vector<string>& gateway,vector<string>& interface,string& errorMessage);

//
int CF_getIfEnabledState(const string& ifName, unsigned int& enabledState ,string& errorMessage);

//
int CF_getSubNetMask(const string& ethName, string& mask, string& errorMessage);

//
int CF_getDefaultGateway(const string& ethName, string& gateway, string& errorMessage);

#endif /*IP_COMMON_H_*/
