/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.style.StyleNumFormatAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleNumLetterSyncAttribute;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;

public class TextTableCountElement
extends OdfElement {
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfDocumentNamespace.TEXT, "table-count");

    public TextTableCountElement(OdfFileDom ownerDoc) {
        super(ownerDoc, ELEMENT_NAME);
    }

    @Override
    public OdfName getOdfName() {
        return ELEMENT_NAME;
    }

    public String getStyleNumFormatAttribute() {
        StyleNumFormatAttribute attr = (StyleNumFormatAttribute)this.getOdfAttribute(OdfDocumentNamespace.STYLE, "num-format");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setStyleNumFormatAttribute(String styleNumFormatValue) {
        StyleNumFormatAttribute attr = new StyleNumFormatAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(styleNumFormatValue);
    }

    public Boolean getStyleNumLetterSyncAttribute() {
        StyleNumLetterSyncAttribute attr = (StyleNumLetterSyncAttribute)this.getOdfAttribute(OdfDocumentNamespace.STYLE, "num-letter-sync");
        if (attr != null) {
            return attr.booleanValue();
        }
        return null;
    }

    public void setStyleNumLetterSyncAttribute(Boolean styleNumLetterSyncValue) {
        StyleNumLetterSyncAttribute attr = new StyleNumLetterSyncAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setBooleanValue(styleNumLetterSyncValue);
    }

    @Override
    public void accept(ElementVisitor visitor) {
        if (visitor instanceof DefaultElementVisitor) {
            DefaultElementVisitor defaultVisitor = (DefaultElementVisitor)visitor;
            defaultVisitor.visit(this);
        } else {
            visitor.visit(this);
        }
    }

    public void newTextNode(String content) {
        if (content != null && !content.equals("")) {
            this.appendChild(this.getOwnerDocument().createTextNode(content));
        }
    }
}

