/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.iterator;

import java.util.Iterator;
import java.util.function.Predicate;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.IteratorSlotted;

public final class IteratorTruncate<T>
extends IteratorSlotted<T> {
    private final Predicate<T> predicate;
    private Iterator<T> iter;

    public IteratorTruncate(Iterator<T> iter, Predicate<T> predicate) {
        this.iter = iter;
        this.predicate = predicate;
    }

    @Override
    protected boolean hasMore() {
        return this.iter.hasNext();
    }

    @Override
    protected T moveToNext() {
        if (!this.iter.hasNext()) {
            return null;
        }
        T item = this.iter.next();
        if (!this.predicate.test(item)) {
            return null;
        }
        return item;
    }

    @Override
    protected void closeIterator() {
        Iter.close(this.iter);
    }
}

