; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown-unknown | FileCheck %s --check-prefixes=X86
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=-slow-incdec | FileCheck %s --check-prefixes=X64,X64-FASTINC
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+slow-incdec | FileCheck %s --check-prefixes=X64,X64-SLOWINC

define i32 @xori64i32(i64 %a) {
; X86-LABEL: xori64i32:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    sarl $31, %eax
; X86-NEXT:    xorl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    retl
;
; X64-LABEL: xori64i32:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    sarq $63, %rax
; X64-NEXT:    xorl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    # kill: def $eax killed $eax killed $rax
; X64-NEXT:    retq
  %shr4 = ashr i64 %a, 63
  %conv5 = trunc i64 %shr4 to i32
  %xor = xor i32 %conv5, 2147483647
  ret i32 %xor
}

define i64 @selecti64i64(i64 %a) {
; X86-LABEL: selecti64i64:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    sarl $31, %edx
; X86-NEXT:    movl %edx, %eax
; X86-NEXT:    xorl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    retl
;
; X64-LABEL: selecti64i64:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    sarq $63, %rax
; X64-NEXT:    xorq $2147483647, %rax # imm = 0x7FFFFFFF
; X64-NEXT:    retq
  %c = icmp sgt i64 %a, -1
  %s = select i1 %c, i64 2147483647, i64 -2147483648
  ret i64 %s
}

define i32 @selecti64i32(i64 %a) {
; X86-LABEL: selecti64i32:
; X86:       # %bb.0:
; X86-NEXT:    xorl %eax, %eax
; X86-NEXT:    cmpl $0, {{[0-9]+}}(%esp)
; X86-NEXT:    sets %al
; X86-NEXT:    addl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    retl
;
; X64-LABEL: selecti64i32:
; X64:       # %bb.0:
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    testq %rdi, %rdi
; X64-NEXT:    sets %al
; X64-NEXT:    addl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    retq
  %c = icmp sgt i64 %a, -1
  %s = select i1 %c, i32 2147483647, i32 -2147483648
  ret i32 %s
}

define i64 @selecti32i64(i32 %a) {
; X86-LABEL: selecti32i64:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    sarl $31, %edx
; X86-NEXT:    movl %edx, %eax
; X86-NEXT:    xorl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    retl
;
; X64-LABEL: selecti32i64:
; X64:       # %bb.0:
; X64-NEXT:    sarl $31, %edi
; X64-NEXT:    movslq %edi, %rax
; X64-NEXT:    xorq $2147483647, %rax # imm = 0x7FFFFFFF
; X64-NEXT:    retq
  %c = icmp sgt i32 %a, -1
  %s = select i1 %c, i64 2147483647, i64 -2147483648
  ret i64 %s
}



define i8 @xori32i8(i32 %a) {
; X86-LABEL: xori32i8:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    sarl $31, %eax
; X86-NEXT:    xorb $84, %al
; X86-NEXT:    # kill: def $al killed $al killed $eax
; X86-NEXT:    retl
;
; X64-LABEL: xori32i8:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    sarl $31, %eax
; X64-NEXT:    xorb $84, %al
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
  %shr4 = ashr i32 %a, 31
  %conv5 = trunc i32 %shr4 to i8
  %xor = xor i8 %conv5, 84
  ret i8 %xor
}

define i32 @selecti32i32(i32 %a) {
; X86-LABEL: selecti32i32:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    sarl $31, %eax
; X86-NEXT:    xorl $84, %eax
; X86-NEXT:    retl
;
; X64-LABEL: selecti32i32:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    sarl $31, %eax
; X64-NEXT:    xorl $84, %eax
; X64-NEXT:    retq
  %c = icmp sgt i32 %a, -1
  %s = select i1 %c, i32 84, i32 -85
  ret i32 %s
}

define i8 @selecti32i8(i32 %a) {
; X86-LABEL: selecti32i8:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    sarl $31, %eax
; X86-NEXT:    xorb $84, %al
; X86-NEXT:    # kill: def $al killed $al killed $eax
; X86-NEXT:    retl
;
; X64-LABEL: selecti32i8:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    sarl $31, %eax
; X64-NEXT:    xorb $84, %al
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
  %c = icmp sgt i32 %a, -1
  %s = select i1 %c, i8 84, i8 -85
  ret i8 %s
}

define i32 @selecti8i32(i8 %a) {
; X86-LABEL: selecti8i32:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    sarb $7, %al
; X86-NEXT:    movsbl %al, %eax
; X86-NEXT:    xorl $84, %eax
; X86-NEXT:    retl
;
; X64-LABEL: selecti8i32:
; X64:       # %bb.0:
; X64-NEXT:    sarb $7, %dil
; X64-NEXT:    movsbl %dil, %eax
; X64-NEXT:    xorl $84, %eax
; X64-NEXT:    retq
  %c = icmp sgt i8 %a, -1
  %s = select i1 %c, i32 84, i32 -85
  ret i32 %s
}

define i32 @icmpasreq(i32 %input, i32 %a, i32 %b) {
; X86-LABEL: icmpasreq:
; X86:       # %bb.0:
; X86-NEXT:    cmpl $0, {{[0-9]+}}(%esp)
; X86-NEXT:    js .LBB8_1
; X86-NEXT:  # %bb.2:
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl (%eax), %eax
; X86-NEXT:    retl
; X86-NEXT:  .LBB8_1:
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl (%eax), %eax
; X86-NEXT:    retl
;
; X64-LABEL: icmpasreq:
; X64:       # %bb.0:
; X64-NEXT:    movl %esi, %eax
; X64-NEXT:    testl %edi, %edi
; X64-NEXT:    cmovnsl %edx, %eax
; X64-NEXT:    retq
  %sh = ashr i32 %input, 31
  %c = icmp eq i32 %sh, -1
  %s = select i1 %c, i32 %a, i32 %b
  ret i32 %s
}

define i32 @icmpasrne(i32 %input, i32 %a, i32 %b) {
; X86-LABEL: icmpasrne:
; X86:       # %bb.0:
; X86-NEXT:    cmpl $0, {{[0-9]+}}(%esp)
; X86-NEXT:    jns .LBB9_1
; X86-NEXT:  # %bb.2:
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl (%eax), %eax
; X86-NEXT:    retl
; X86-NEXT:  .LBB9_1:
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl (%eax), %eax
; X86-NEXT:    retl
;
; X64-LABEL: icmpasrne:
; X64:       # %bb.0:
; X64-NEXT:    movl %esi, %eax
; X64-NEXT:    testl %edi, %edi
; X64-NEXT:    cmovsl %edx, %eax
; X64-NEXT:    retq
  %sh = ashr i32 %input, 31
  %c = icmp ne i32 %sh, -1
  %s = select i1 %c, i32 %a, i32 %b
  ret i32 %s
}

define i32 @oneusecmp(i32 %a, i32 %b, i32 %d) {
; X86-LABEL: oneusecmp:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    sarl $31, %eax
; X86-NEXT:    xorl $127, %eax
; X86-NEXT:    testl %ecx, %ecx
; X86-NEXT:    js .LBB10_1
; X86-NEXT:  # %bb.2:
; X86-NEXT:    leal {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    addl (%ecx), %eax
; X86-NEXT:    retl
; X86-NEXT:  .LBB10_1:
; X86-NEXT:    leal {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    addl (%ecx), %eax
; X86-NEXT:    retl
;
; X64-LABEL: oneusecmp:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    sarl $31, %eax
; X64-NEXT:    xorl $127, %eax
; X64-NEXT:    testl %edi, %edi
; X64-NEXT:    cmovsl %edx, %esi
; X64-NEXT:    addl %esi, %eax
; X64-NEXT:    retq
  %c = icmp sle i32 %a, -1
  %s = select i1 %c, i32 -128, i32 127
  %s2 = select i1 %c, i32 %d, i32 %b
  %x = add i32 %s, %s2
  ret i32 %x
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; X64-FASTINC: {{.*}}
; X64-SLOWINC: {{.*}}
